/*
 * Decompiled with CFR 0.152.
 */
package jace.applesoft;

import jace.applesoft.Command;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Line {
    private static char STATEMENT_BREAK = (char)58;
    private int number;
    private Line next;
    private Line previous;
    private List<Command> commands = new ArrayList<Command>();
    private int length;

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public Line getNext() {
        return this.next;
    }

    public void setNext(Line next) {
        this.next = next;
    }

    public Line getPrevious() {
        return this.previous;
    }

    public void setPrevious(Line previous) {
        this.previous = previous;
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    public void setCommands(List<Command> commands) {
        this.commands = commands;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String toString() {
        String out = String.valueOf(this.getNumber());
        boolean isFirst = true;
        for (Command c : this.commands) {
            if (!isFirst) {
                out = out + STATEMENT_BREAK;
            }
            out = out + c.toString();
            isFirst = false;
        }
        return out;
    }

    static Line fromBinary(byte[] binary, int pos) {
        Line l = new Line();
        int lineNumber = (binary[pos + 2] & 0xFF) + ((binary[pos + 3] & 0xFF) << 8);
        l.setNumber(lineNumber);
        pos += 4;
        Command c = new Command();
        int size = 5;
        while (binary[pos] != 0) {
            ++size;
            if (binary[pos] == STATEMENT_BREAK) {
                l.commands.add(c);
                c = new Command();
            } else {
                Command.ByteOrToken bt = new Command.ByteOrToken(binary[pos]);
                c.parts.add(bt);
            }
            ++pos;
        }
        l.commands.add(c);
        l.length = size;
        return l;
    }
}

